\version "2.24.0"
\language "deutsch"

\paper {
  %between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 20))
  %system-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Nun danket alle Gott"
  %subtitle = "Für Lorena (*8.11.2020)"
  subsubtitle = "BWV 252"
  %poet = \markup \center-column { "nach Padre Pio" \small 
  %"(1887 - 1968)" }
  composer = "Martin Rinckart (1586–1649)"
  arranger = "J. S. Bach (1685-1750)"
  %meter = "Andante sostenuto"
  tagline=""
}

global = {
  \key g \major
  %\autoBeamOn
  %\cadenzaOn
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWordsOneA = \lyricmode {
  \set stanza = "1."
  Nun dan -- ket al -- le __ Gott
  mit Her -- zen, Mund und Hän -- den,
}
 
sopWordsOneB = \lyricmode {
  der gro -- ße Din -- ge tut
  an uns und al -- len En -- den, 
  der uns von Mut -- ter -- leib
  und Kin -- des -- bei -- nen __ an
  un -- zäh -- lig viel zu __ gut
  bis hier -- her hat ge -- tan.
}

sopWordsTwoA = \lyricmode {
  \set stanza = "2."
  Der e -- wig -- rei -- che Gott
  woll uns bei un -- serm Le -- ben
}

sopWordsTwoB = \lyricmode {
  ein im -- mer fröh -- lich Herz
  und ed -- len Frie -- den ge -- ben
  und uns in Sei -- ner Gnad'
  er -- hal -- ten fort und __ fort
  und uns __ aus al -- ler Not
  er -- lö -- sen hier und dort.
}

sopWordsThreeA = \lyricmode {
  \set stanza = "3."
  Lob, Ehr und Preis sei Gott,
  dem Va -- ter und dem Soh -- ne
}

sopWordsThreeB = \lyricmode {
  und Gott dem Heil' -- gen Geist
  im höch -- sten Him -- mels -- thro -- ne,
  Ihm, dem drei -- ei -- nen Gott,
  wie es im An -- fang __ war
  und ist __ und blei -- ben wird
  so jetzt und im -- mer -- dar.
}

bassWords = \lyricmode {
  
  A -- li -- lu -- i -- a, a -- li -- lu -- i -- a,
  a -- li -- lu -- ia.
}

sopMusic = \relative c'' {
  \repeat volta 2 {
  d4 d d e e d2. ^\fermata
  h4 c h a h8( c) a2 g4 ^\fermata
   }
  a4 a a h h a2. ^\fermata
  a4 h8( cis) d4 4 cis d2. ^\fermata
  d4 e d c h c2. ^\fermata
  h4 a h8( c) a4. g8 g2. ^\fermata  
  \bar"|."
}

altMusic = \relative c'' {
  \repeat volta 2 {
  g4 a g g g8( a) h2. 
  g4 a d, d d e16( fis g4 fis8) d4
   }
  fis8( g) a([ g]) a( fis) d4 g fis2.
  fis4 d8( e) fis4 h a8( g) fis2. 
  g4 g8( a) h4 h8([ a]) a( gis) a2.
  d,4 d4. e8 d( g) fis4 d2.  
}

tenorMusic = \relative c' {
  \repeat volta 2 {
  h4 a8( d) h4 c c d2.
  d4 d4. g8 fis4 g8( g,) e'4( a,) h
   }
  a4 d c h8( c) d4 d2.
  d8( c) h([ a]) a( d) d([ g]) e16( d e8) d2.
  h4 c d8( e16 f) g8([ c,]) f( e) e2.
  g4 fis8([ d]) h( a) a([ h]) c( a) h2.
}

bassMusic = \relative c' {
  \repeat volta 2 {
  g4 fis g c,8([ d]) e( c) g'2.
  g4 g8( fis) g4 d8([ c]) h( e) c8( h16 c d4) g,
   }
  d'8( e) fis([ e]) fis( d) g,([ a]) h( c) d2.
  d4 g fis8( h) g([ e]) a( a,) d2.
  g4 c, g'8( f) e([ f]) d( e) a,2.
  h8( g) d'([ fis]) g( c,) d4 d, g2.  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \voiceOne \sopMusic }
     \new Voice { \global \voiceTwo \altMusic }
     \addlyrics { \sopWordsOneA }
     \addlyrics { \sopWordsOneB }
     \addlyrics { \sopWordsTwoA }
     \addlyrics { \sopWordsTwoB }
     \addlyrics { \sopWordsThreeA }
     \addlyrics { \sopWordsThreeB }
     %\new Voice { \global \voiceTwo \altMusic }
     %\addlyrics { \sopWords }
    >>
      
    \new Staff <<
     \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      %\addlyrics { \sopWordsOne }
      %\new Lyrics \lyricsto "split" { a -- şa, a -- şa şi pre pă -- mânt. }
     >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 70
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}